#include <iostream>
#include <iomanip>
#include <string>

#include <stdio.h>
#include <pcap.h>
#include <pcap-int.h>
#include <Packet32.h>
#include <ntddndis.h>
#include <winsock.h>

#include "ETHHeader.h"
#include "IPHeader.h"
#include "ICMPHeader.h"
#include "ARPHeader.h"
#include "UDPHeader.h"
#include "BOOTPHeader.h"


using namespace std;

u_char broadcastMAC[ETH_ALEN] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
u_char broadcastIP[IP_ALEN] = {0xFF, 0xFF, 0xFF, 0xFF};
u_char unknownIP[IP_ALEN] = {0, 0, 0, 0};

u_char srcMAC[ETH_ALEN];
u_char dstMAC[ETH_ALEN] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

u_char dstIPch[IP_ALEN];
u_int dstIP;
u_char srcIPch[IP_ALEN]; // = {192, 168, 0, 3}; // protoze mi DHCP server vraci v options same 0
u_int srcIP = IP_ch2int(srcIPch);
u_char NetMaskCh[IP_ALEN] = {255, 255, 255, 0};
u_int NetMask = IP_ch2int(NetMaskCh);
u_char GWIPch[IP_ALEN];
u_int GWIP;


bool get_MAC_addr(const pcap_t *fp, u_char mac[ETH_ALEN])
{
  struct {
    _PACKET_OID_DATA base;
    u_char buff[512];
  } req;
  req.base.Oid = OID_802_3_CURRENT_ADDRESS;
  req.base.Length = 6;
  if (!PacketRequest(fp->adapter, 0, &req.base)) return false;
  memcpy(mac, req.base.Data, ETH_ALEN);
  return true;
}

void received_packet(u_char *user, const struct pcap_pkthdr *pkt_header, const u_char *pkt_data)
{
  cout << "Receive packet [received_packet function]" << endl;
  cout << "=========================================" << endl;

  ETHHeader eth = ETHHeader(pkt_data);
  if (eth.frame_type() == ETH_FRAME_IP)
  {
    IPHeader iph = IPHeader(pkt_data + ETH_HEADER_SIZE);
    if (iph.protocol() == IPPROTO_ICMP)
    {
      ICMPHeader icmph = ICMPHeader(pkt_data + ETH_HEADER_SIZE + IP_HEADER_SIZE, iph.total_length() - IP_HEADER_SIZE);
      eth.dump();
      iph.dump();
      icmph.dump();
      if (icmph.type() == ICMP_ECHO_REPLY_TYPE && Compare(eth.dst_MAC(), srcMAC, ETH_ALEN) 
        && (iph.dest() == srcIP) && (iph.source() == dstIP))
      {
        cout << "ICMP echo reply recived." << endl << endl << endl;
      }
    }        
  }
  if (eth.frame_type() == ETH_FRAME_ARP)
  {
    ARPHeader arph = ARPHeader(pkt_data + ETH_HEADER_SIZE);
    eth.dump();
    arph.dump();
  }

  cout << "Receive packet [received_packet function] END" << endl;
  cout << "=============================================" << endl;
}

void receive_ARP_reply(u_char *user, const struct pcap_pkthdr *pkt_header, const u_char *pkt_data)
{
  cout << "Receive packet [receive_ARP_reply function]" << endl;
  cout << "===========================================" << endl;

  ETHHeader eth = ETHHeader(pkt_data);
  if (eth.frame_type() == ETH_FRAME_ARP )
  {        
    ARPHeader arph = ARPHeader(pkt_data + ETH_HEADER_SIZE);
    eth.dump();            
    arph.dump();

    if (arph.opcode() == ARP_OP_REPLY && Compare(eth.dst_MAC(), srcMAC, ETH_ALEN) && Compare(arph.dstIP(), srcIPch, IP_ALEN))
    {
      cout << "ARP reply recived." << endl;
      memcpy(dstMAC, arph.srcMAC(), ETH_ALEN);
      cout << "Dst MAC is ";
      printMACAddress(dstMAC);
      cout << endl << endl << endl;
    }
  }

  cout << "Receive packet [receive_ARP_reply function] END" << endl;
  cout << "===============================================" << endl;
}

void receive_BOOTP_reply(u_char *user, const struct pcap_pkthdr *pkt_header, const u_char *pkt_data)
{
  cout << "Receive packet [receive_BOOTP_reply function]" << endl;
  cout << "=============================================" << endl;

  ETHHeader eth = ETHHeader(pkt_data);
  if (eth.frame_type() == ETH_FRAME_IP)
  {        
    IPHeader iph = IPHeader(pkt_data + ETH_HEADER_SIZE);
    if (iph.protocol() == IPPROTO_UDP)
    {
      UDPHeader udph = UDPHeader(pkt_data + ETH_HEADER_SIZE + IP_HEADER_SIZE);
      if (udph.dstPort() == SERVICE_BOOTPC || udph.dstPort() == SERVICE_BOOTPS)
      {
        BOOTPHeader bootph = BOOTPHeader(pkt_data + ETH_HEADER_SIZE + IP_HEADER_SIZE + UDP_HEADER_SIZE);
        eth.dump();
        iph.dump();
        bootph.dump();
        if (bootph.Opcode() == BOOTP_OP_REPLY && Compare(eth.dst_MAC(), srcMAC, ETH_ALEN))
        {
          cout << "BOOTP reply received. Assigned IP: ";
          printIPAddress(bootph.YourIP());
          memcpy(srcIPch, bootph.YourIP(), IP_ALEN);
		  srcIP = IP_ch2int(srcIPch);
		  // memcpy(NetMaskCh, bootph., IP_ALEN);          
		  // NetMask = IP_ch2int(NetMaskCh);
		  memcpy(GWIPch, bootph.GatewayIP(), IP_ALEN);
		  GWIP = IP_ch2int(GWIPch);
          cout << endl << endl << endl;
        }
      }
    }    
  }

  cout << "Receive packet [receive_BOOTP_reply function] END" << endl;
  cout << "=================================================" << endl;
}

int main(int argc, char* argv[])
{	
	srand(time(NULL));    

	pcap_t *fp;
	char error[PCAP_ERRBUF_SIZE];


	/* 
	 * adresa na kterou se ma pingnout (destination address)
	 * dstIP, dstIPch
	 */
	if (argc == 1) {
		printf("Type destination IP address: ");
		char IPstr[255];
		scanf("%s",&IPstr);		
		dstIP = IP_str2int(IPstr);
		IP_str2ch(IPstr,dstIPch);
	}
	else if (argc == 2) {
		dstIP = IP_str2int(argv[1]);
		IP_str2ch(argv[1],dstIPch);
	} else {
		printf("Bad parameters count!\nUsage: <exe_file> xxx.xxx.xxx.xxx");
	}


  /* 
   * zjisteni a vyber ifc v PC 
   */
  pcap_if_t *devlist, *d;
  int i;

  cout << "\n\nSupported interfaces:" << endl;

  if (pcap_findalldevs(&devlist, error) == -1) {
    cerr << "\tUnable to retrieve the list: " << error << endl;
    return 2;
  }

  for (i=0, d=devlist; d; d=d->next, i++) {
    cout << i+1 << ") " << d->name << "\n\t(";
    if (d->description)
      cout << d->description << ")\n";
    else
      cerr << "No description available)\n";
  }
  if (i == 0) {
    cerr << "\tNo interfaces found. Check that WinPCap is installed!\n";
  }

  cout << "Choice interface: ";
  int ifcNr;
  cin >> ifcNr;
  cout << endl << endl;

  pcap_findalldevs(&devlist, error);
  string intrf;

  for (i=0, d=devlist; d; d=d->next, i++) {
    if( i == ifcNr - 1) {
      intrf = d->name;
    }
  }

  pcap_freealldevs(devlist);

  if((fp = pcap_open_live(intrf.c_str(), 1024, 0, 100, error)) == NULL)
  {
    cerr << "Exiting, " << error << endl;
    return 1;
  }

  if (!get_MAC_addr(fp, srcMAC)) {
    cerr << "Unable to retrieve my MAC address, exiting" << endl;
    return 1;
  }
  cout << "My MAC address: ";
  printMACAddress(srcMAC);
  cout << endl << endl;


#define DATA_LEN 76

  //  --- BOOTP ---
  ETHHeader eth = ETHHeader(broadcastMAC, srcMAC, ETH_FRAME_IP);
  IPHeader iph = IPHeader(IP_ch2int(broadcastIP), IP_ch2int(unknownIP), IPPROTO_UDP, UDP_HEADER_SIZE + BOOTP_HEADER_SIZE);
  UDPHeader udph = UDPHeader(SERVICE_BOOTPC, SERVICE_BOOTPS, BOOTP_HEADER_SIZE);
  BOOTPHeader bootph = BOOTPHeader(BOOTP_OP_REQUEST, rand(), srcMAC);
  u_char *packet = (u_char *)malloc(ETH_HEADER_SIZE + IP_HEADER_SIZE + UDP_HEADER_SIZE + BOOTP_HEADER_SIZE);
  memset(packet, 0, ETH_HEADER_SIZE + IP_HEADER_SIZE + UDP_HEADER_SIZE + BOOTP_HEADER_SIZE);
  eth.setMem(packet);
  iph.setMem(packet + ETH_HEADER_SIZE);
  udph.setMem(packet + ETH_HEADER_SIZE + IP_HEADER_SIZE);
  bootph.setMem(packet + ETH_HEADER_SIZE + IP_HEADER_SIZE + UDP_HEADER_SIZE);

  cout << "Sending BOOTP request... ";
  bool success = pcap_sendpacket(fp, packet, ETH_HEADER_SIZE + IP_HEADER_SIZE + UDP_HEADER_SIZE + BOOTP_HEADER_SIZE) >= 0;
  cout << "BOOTP " << success << endl;
  if (pcap_dispatch(fp, 10, receive_BOOTP_reply, packet) < 0)
	{
		cerr << "No response for BOOTP request." << endl;
		free(packet);
		return 1;
	}
  free(packet);


	
  // --- porovnam IP / mask => na co se ptat ARP ---
  u_char *ARPreqIP;

  if ((dstIP & NetMask) == (srcIP & NetMask)) {
	// dstIP v me siti => arp primo na dstIP
	ARPreqIP = dstIPch;
	cout << "Dst IP is in some subnet. Sending ARP req 'direct' to Dst" << endl;
  } else {
	ARPreqIP = GWIPch;
	cout << "Dst IP isn't in some subnet. Sending ARP req to GW" << endl;
  }



  //  --- ARP ---
  eth = ETHHeader(broadcastMAC, srcMAC, ETH_FRAME_ARP);
  ARPHeader arph = ARPHeader(ARP_OP_REQUEST, srcMAC, broadcastMAC, srcIPch, ARPreqIP);

  packet = (u_char *)malloc(ETH_HEADER_SIZE + ARP_HEADER_SIZE);
  memset(packet, 0, ETH_HEADER_SIZE + ARP_HEADER_SIZE);
  eth.setMem(packet);
  arph.setMem(packet + ETH_HEADER_SIZE);

  cout << "Sending ARP query for address ";
  printIPAddress(ARPreqIP);
  cout << endl;
  success = pcap_sendpacket(fp, packet, ETH_HEADER_SIZE + ARP_HEADER_SIZE) >= 0;
  cout << "ARP " << success << endl;

	if (pcap_dispatch(fp, 2, receive_ARP_reply, packet) < 0)
	{
		cerr << "No response for ARP query. " << endl;
		free(packet);
		return 1;
	}
  free(packet);

  //  --- ICMP ---
  u_char *data = (u_char *)malloc(DATA_LEN);
  memset(data, 0, DATA_LEN);
  for (int i = 0; i < DATA_LEN; i++)
    data[i] = rand();

  eth = ETHHeader(dstMAC, srcMAC, ETH_FRAME_IP);
  iph = IPHeader(dstIP, srcIP, IPPROTO_ICMP, ICMP_HEADER_SIZE + DATA_LEN);
  ICMPHeader icmph = ICMPHeader(8, 130, 0, data, DATA_LEN);

  packet = (u_char *)malloc(ETH_HEADER_SIZE + IP_HEADER_SIZE + ICMP_HEADER_SIZE + DATA_LEN);
  memset(packet, 0, ETH_HEADER_SIZE + IP_HEADER_SIZE + ICMP_HEADER_SIZE + DATA_LEN);
  eth.setMem(packet);
  iph.setMem(packet + ETH_HEADER_SIZE);
  icmph.setMem(packet + ETH_HEADER_SIZE + IP_HEADER_SIZE);

  cout << "Sending ICMP echo query" << endl;
  success = pcap_sendpacket(fp, packet, ETH_HEADER_SIZE + IP_HEADER_SIZE + ICMP_HEADER_SIZE + DATA_LEN) >= 0;
  cout << "ICMP " <<  success << endl;

  free(data);
  free(packet);

  if (pcap_loop(fp, -1, received_packet, (u_char *)fp) < 0) {
    cerr << "Error in pcap_dispatch()" << endl;
    return 1;
  }

  return 0;
}